DATASETS = {
    'charades': {
        'video_path': './Charades/Charades_v1',
        'stride': 20,
        'max_stride_factor': 0.5,
        'splits': {
            'default': {
                'annotation_file': 'dataset/charades-sta/charades_test.json',
                'pad_sec': 0.0,
            },
            'small': {
                'annotation_file': 'dataset/charades-sta/charades_test_small.json',
                'pad_sec': 0.0,
            },
            'OOD-1': {
                'annotation_file': 'dataset/charades-sta/charades_test.json',
                'pad_sec': 10.0,
            },
            'OOD-2': {
                'annotation_file': 'dataset/charades-sta/charades_test.json',
                'pad_sec': 15.0,
            },
            'test-ood': {
                'annotation_file': 'dataset/charades-sta/charades_test_ood.json',
                'pad_sec': 0.0,
            },
            'novel-composition': {
                'annotation_file': 'dataset/charades-sta/novel_composition.json',
                'pad_sec': 0.0,
            },
            'novel-word': {
                'annotation_file': 'dataset/charades-sta/novel_word.json',
                'pad_sec': 0.0,
            },
        }
    },
    'activitynet': {
        'video_path': './activitynet/videos',
        'stride': 40,
        'max_stride_factor': 1,
        'splits': {
            'default': {
                'annotation_file': 'dataset/activitynet/test.json',
                'pad_sec': 0.0,
            },
            'OOD-1': {
                'annotation_file': 'dataset/activitynet/test.json',
                'pad_sec': 30.0,
            },
            'OOD-2': {
                'annotation_file': 'dataset/activitynet/test.json',
                'pad_sec': 60.0,
            },
        }
    },
    'qvhighlight': {
        'feature_path': '/home/zhengmh/Datasets/qvhighlight/blip2_coco_features/',
        'stride': 50,
        'max_stride_factor': 0.5,
        'splits': {
            'default': {
                'annotation_file': 'dataset/qvhighlight/highlight_val_release.jsonl',
                'pad_sec': 0.0,
            },
        }
    },
    'scanrefer': {
        'video_path': '/data2/datasets/scannet/video',
        'stride': 20,
        'max_stride_factor': 0.5,
        'splits': {
            'default': {
                'annotation_file': 'dataset/scanrefer/val.json',
                'pad_sec': 0.0,
            },
            'default_10': {
                'annotation_file': 'dataset/scanrefer/val_10.json',
                'pad_sec': 0.0,
            },
            'train': {
                'annotation_file': 'dataset/scanrefer/train.json',
                'pad_sec': 0.0,
            },
        }
    },
    'sqa3d': {
        'video_path': '/data2/datasets/scannet/video',
        'splits': {
            'default': {
                'annotation_file': 'dataset/sqa3d/SQA_val.json',
                'pad_sec': 0.0,
            },
        }
    },
    'scanrefer_image': {
        'splits': {
            'default': {
                'annotation_file': 'dataset/scanrefer/img_g_val.json',
                'pad_sec': 0.0,
            },
            'train': {
                'annotation_file': 'dataset/scanrefer/img_g_train.json',
                'pad_sec': 0.0,
            },
            'test': {
                'annotation_file': 'dataset/scanrefer/vis.json',
                'pad_sec': 0.0,
            }
        }
    },
    'scenefun3d': {
        'video_path': '/data2/datasets/scenefun3d_video',
        'splits': {
            'default': {
                'annotation_file': 'dataset/scenefun3d/val.json',
                'pad_sec': 0.0,
            }
        }
    },
    'scenefun3d_image': {
        'splits': {
            'default': {
                'annotation_file': 'dataset/scenefun3d/img_g_val.json',
                'pad_sec': 0.0,
            },
            'train': {
                'annotation_file': 'dataset/scenefun3d/img_g_train.json',
                'pad_sec': 0.0,
            }
        }
    },
}
